;**********************************************
; Test I/O (ET-TEST I/O)
; Hardware  : CP-PIC877 V1.0 & V2.0
; file name : test_io.ASM
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 19/10/2002
;**********************************************

     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions

     __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _XT_OSC & _WRT_ENABLE_ON & _LVP_ON & _DEBUG_OFF & _CPD_OFF


count     EQU       0x20
DT1       EQU       0x21
DT2	  EQU       0x22
buffer	  EQU  	    0x23

          ORG       0x0000

;************ initial *******************
init      bsf       STATUS,RP0     ; select bank 1
          clrf      TRISA	   ; PORTA as output
	  movlw     0xff	   ; PORTB as input
	  movwf     TRISB
	  clrf	    TRISC	   ; PORTC as output
          bcf       STATUS,RP0     ; select bank 0

       	  clrf	    PORTA	   ; clear PORTA
	  clrf	    PORTC	   ; clear PORTC

;********** main program  ****************

start     movlw	    .7	      	   ; counter loop = 7
	  movwf     count
	  movlw     PORTA	   
	  movwf     FSR            ; FSR point to PORTA
	  call      loop	   ; sub program moving LED

	  movlw	    .9		   ; counter loop = 9
	  movwf	    count
	  movlw     PORTC	   ; FSR point to PORTC 
	  movwf	    FSR
	  call      loop
	  goto	    start

loop      movlw	    0x01 	   ; data for output port
	  movwf     buffer
next	  movf	    buffer,w	   ; w = buffer
	  movwf     INDF	   ; out data to output port
	  call      delay
	  bcf	    STATUS,C	   ; clear carry flag
	  rlf	    buffer,f	   ; rotate data
	  decfsz    count,f
	  goto      next
	  return

;********* delay loop ********************  

delay     movf	    PORTB,w
	  movwf     DT1
del	  clrf      DT2
del0      decfsz    DT2,f
	  goto	    $-1
	  decfsz    DT1,f
	  goto	    del
	  return


          END
